#!/usr/bin/env python        	

# Tommy A. Bertelsen / kittens.Voice  (C)2016 
# Special guest coder/reviewer: Aleksander Bertelsen / alek52000
# A CodeBrothers Project

# IMPORTant business
import socket, json, math, thread, sys
from random import randint
from time import sleep
from player import Player
from enemy import Enemy

#TCP because why not?
game_socket = socket.socket()   
host = socket.gethostname() 	
#host = '127.0.0.1' #Set host and port if you are going to remote connect to server... 
port = 54321

# Have to let you guyes know that something is actually going on here... 
print "Connecting to server [" + host + ":" + str(port) + "]..."
try:
  game_socket.connect((host, port))
except:
  print "An error occured when trying to connect to server... The BOT cannot run. Please check that the IP/port is correct."
  sys.exit()
print "Connected! Godspeed Voice.BOT"

game_socket.send(b"NAME Voice.BOT\n")

# Instanciate such a player!
player = Player()

# GLOBAL WARNING INCOMING
enemies = []

missileLoaded = True
seekingLoaded = True
mineLoaded    = True
accelerateOK  = True
angle_offset = 0

# "Stay classy San Diego". 
class Move(object):
  ACCELERATE=0
  MINE=1
  RIGHT=2
  LEFT=3
  MISSILE=4
  SEEKING=5
  
# You know you want it. 
def messageType(j_obj):
  return j_obj['messagetype']

# "I like to move it, move it..."
def performNextMove(move):
  if(move == Move.ACCELERATE):
    game_socket.send(b"ACCELERATE\n")
  elif(move == Move.MINE):
    game_socket.send(b"MINE\n")
  elif(move == Move.RIGHT):
    game_socket.send(b"RIGHT\n")
  elif(move == Move.LEFT):
    game_socket.send(b"LEFT\n")
  elif(move == Move.MISSILE):
    game_socket.send(b"MISSILE\n")
  elif(move == Move.SEEKING):
    game_socket.send(b"SEEKING\n")

#NOT REALLY TODO: Use genetic algorithms to train the Neural Network.
#MAJOR CHANGE OF PLANS: Screw NEAT and NN, aint nobody got time fo' dat! I'm going in dry: semi-retarded statemachine... 

# This is one hell of a messed up function...
def calculateNextMove(json_obj):
  global angle_offset
  angle_delta = 0
  distance = 0.0
  # If new state update:
  if(messageType(json_obj) == 'stateupdate'):
    #Player:
    if(player.isAlive() == True):
      energy 			= json_obj['gamestate']['you']['energy']
      id 				  = json_obj['gamestate']['you']['id']
      rotation 		= json_obj['gamestate']['you']['rotation']
      vel_x 			= json_obj['gamestate']['you']['velocityX']
      vel_y 			= json_obj['gamestate']['you']['velocityY']
      pos_x 			= json_obj['gamestate']['you']['x']
      pos_y 			= json_obj['gamestate']['you']['y']
      player.update(energy, rotation, vel_x, vel_y, pos_x, pos_y)

    #Other players info
    shortest_distance = 100
    enemy_id = 0
    closest_pos_x = 0.0
    closest_pos_y = 0.0
    if len(json_obj['gamestate']['others']) > 0:
      for i in range(0, len(json_obj['gamestate']['others'])):
        energy 		= json_obj['gamestate']['others'][i]['energy']
        id 			  = json_obj['gamestate']['others'][i]['id']
        rotation 	= json_obj['gamestate']['others'][i]['rotation']
        vel_X 		= json_obj['gamestate']['others'][i]['velocityX']
        vel_Y 		= json_obj['gamestate']['others'][i]['velocityY']
        pos_x 		= json_obj['gamestate']['others'][i]['x']
        pos_y 		= json_obj['gamestate']['others'][i]['y']
       
        if(len(enemies) <= i):
          enemy = Enemy(energy, id, rotation, vel_X, vel_Y, pos_x, pos_y)
          enemies.append(enemy)
        else:
          enemies[i].update(energy, id, rotation, vel_X, vel_Y, pos_x, pos_y)
          
        distance = calculateDistance(player.getPosX(), pos_x, player.getPosY(), pos_y)
        if(distance < shortest_distance):
          shortest_distance = distance
          enemy_id = id
          closest_pos_x = pos_x
          closest_pos_y = pos_y
     
      dx = closest_pos_x - player.getPosX()
      dy = closest_pos_y - player.getPosY()
      angle = math.atan2(dy, dx) * (180.0 / math.pi)
      angle = int(angle) % 360
      angle_delta = angle - int(player.getRotation())
      angle_delta = (angle_delta + 180) % 360 - 180
      
      # Some debug info is neat
      #print str(enemy_id) + ": " + str(shortest_distance) + ", Target angle: " + str(angle) + ", Player Angle: " + str(player.getRotation()) + ", Angle Delta: " + str(angle_delta)
      
      angle_offset = -randint(20, 21) - (1.0/shortest_distance)
   
  if(messageType(json_obj) == 'dead'):
    player.setEnergy(0)
    player.setAlive(False)

  if(messageType(json_obj) == 'endofround'):
    player.reset()    
    
  # ----- Really black magic goes below here -----
  if(distance < 0.5):
    angle_offset = 90
    if(seekingLoaded and player.getEnergy() > 200):
      try:
        thread.start_new_thread(fire, (Move.SEEKING, 0.01))
      except:
        print "Unable to start thread [fire SEEKING]"
  
  # Debug all over the place. 
  #print "angle_delta: " + str(angle_delta) + ", angle_offset: " + str(angle_offset)
  
  # Left or right? Blue or red? Hell, it works...
  if(angle_delta <= angle_offset):
    performNextMove(Move.LEFT)
  else:
    performNextMove(Move.RIGHT)
  
  # At this point I realised I had no idea what I was doing... Nothing to see here!
  if(angle_delta < 15+angle_offset and angle_delta > -15+angle_offset and distance > 0.5):
    if(accelerateOK):
      random_delay = randint(1, 4)/10.0
      
      # MULTITHREAD? Are you MAD SON?
      try:
        random_move = randint(1, 100)
        if(random_move > 15):
          move = 0
          random_fire = randint(1, 100)
          if(random_fire < 92):
            move = Move.MISSILE
          elif(random_fire >= 92):
            move = Move.MINE
          thread.start_new_thread(fire, (move, 0.01))
        elif(random_move <= 15):
          thread.start_new_thread(accel, (random_delay,))
      except:
        print "Unable to start thread [ACCELERATE]"
        
# "Do a barrel roll"
def gameLoop():
  data_conc = ''
  error_count = 0
  while True:
    #<trollface>sleep(50.0/1000.0) # NOPE, not gonna sleep here </trollface>
    data = game_socket.recv(4096)
    data_conc += data
    
    #<trollface>Thank you for making the parsing of JSON-objects from TCP-socket look so easy and goodlooking...</trollface>
    if '\n' in data_conc:
      split_data = data_conc.splitlines()
      
      for i in range(len(split_data)):
        #print split_data[i] + '\n'
        if(i >= len(split_data)):
          data_conc = split_data[i]
          break
          
        # data_conc MUST BE FLUSHED, or else you're in TROUBLE, MISTER!
        data_conc = '' 
        if(split_data[i].startswith("{") and split_data[i].endswith("}")
        and ("dead" in split_data[i] or "endofround" in split_data[i] or "stateupdate" in split_data[i]
        and ("gamestate" in split_data[i]))):
          try:
            json_obj = json.loads(split_data[i])
           
            calculateNextMove(json_obj)
            
          except ValueError:
            error_count = error_count + 1
            print "An error occured [" + str(error_count) + "] while trying to load json using the following data: " + str(split_data[i])         

# "TRIGONOMETRY!" aka stay in school, kids!
def calculateDistance(x1, x2, y1, y2):
  distance = math.sqrt(math.pow(x1-x2, 2) + math.pow(y1-y2, 2))
  return distance
  
# Why is this even here?!?
def calculateRotation():
  rotation = 0
  return rotation

# "Continue with the operation, you may fire when ready..."
def fire(type, delay):
  global missileLoaded, seekingLoaded, mineLoaded
  if(type is Move.MISSILE):
    missileLoaded = False
  elif(type is Move.SEEKING):
    seekingLoaded = False
  elif(type is Move.MINE):
    mineLoaded = False

  # FINALLY something is happening...
  performNextMove(type)
  sleep(delay)
  
  if(type is Move.MISSILE):
    missileLoaded = True
  elif(type is Move.SEEKING):
    seekingLoaded = True
  elif(type is Move.MINE):
    mineLoaded = True

# "PUNCH IT, CHEEWIE!!!"
def accel(delay):
  global accelerateOK
  accelerateOK = False
  performNextMove(Move.ACCELERATE)
  sleep(delay)
  accelerateOK = True
  
# No main, no game...
def main():
  gameLoop()
  game_socket.close()

# LOL THIS LOOK SO SILLY -_- "EXECUTE ORDER 66"
if __name__ == "__main__":
  main()